
/*
 * Copyright 2020, Data61, CSIRO (ABN 41 687 119 230)
 ** SPDX-License-Identifier: BSD-2-Clause
 */

/* This header was generated by kernel/tools/invocation_header_gen.py.
 *
 * To add an invocation call number, edit libsel4/include/interfaces/sel4.xml.
 *
 */
#pragma once

enum invocation_label {
    InvalidInvocation,
    UntypedRetype,
    TCBReadRegisters,
    TCBWriteRegisters,
    TCBCopyRegisters,
#if !defined(CONFIG_KERNEL_MCS)
    TCBConfigure,
#endif
#if defined(CONFIG_KERNEL_MCS)
    TCBConfigure,
#endif
    TCBSetPriority,
    TCBSetMCPriority,
#if !defined(CONFIG_KERNEL_MCS)
    TCBSetSchedParams,
#endif
#if defined(CONFIG_KERNEL_MCS)
    TCBSetSchedParams,
#endif
#if defined(CONFIG_KERNEL_MCS)
    TCBSetTimeoutEndpoint,
#endif
    TCBSetIPCBuffer,
#if !defined(CONFIG_KERNEL_MCS)
    TCBSetSpace,
#endif
#if defined(CONFIG_KERNEL_MCS)
    TCBSetSpace,
#endif
    TCBSuspend,
    TCBResume,
    TCBBindNotification,
    TCBUnbindNotification,
#if (!defined(CONFIG_KERNEL_MCS) && defined(CONFIG_ENABLE_SMP_SUPPORT))
    TCBSetAffinity,
#endif
#if defined(CONFIG_HARDWARE_DEBUG_API)
    TCBSetBreakpoint,
#endif
#if defined(CONFIG_HARDWARE_DEBUG_API)
    TCBGetBreakpoint,
#endif
#if defined(CONFIG_HARDWARE_DEBUG_API)
    TCBUnsetBreakpoint,
#endif
#if defined(CONFIG_HARDWARE_DEBUG_API)
    TCBConfigureSingleStepping,
#endif
    TCBSetTLSBase,
    CNodeRevoke,
    CNodeDelete,
    CNodeCancelBadgedSends,
    CNodeCopy,
    CNodeMint,
    CNodeMove,
    CNodeMutate,
    CNodeRotate,
#if !defined(CONFIG_KERNEL_MCS)
    CNodeSaveCaller,
#endif
    IRQIssueIRQHandler,
    IRQAckIRQ,
    IRQSetIRQHandler,
    IRQClearIRQHandler,
    DomainSetSet,
#if defined(CONFIG_KERNEL_MCS)
    SchedControlConfigureFlags,
#endif
#if defined(CONFIG_KERNEL_MCS)
    SchedContextBind,
#endif
#if defined(CONFIG_KERNEL_MCS)
    SchedContextUnbind,
#endif
#if defined(CONFIG_KERNEL_MCS)
    SchedContextUnbindObject,
#endif
#if defined(CONFIG_KERNEL_MCS)
    SchedContextConsumed,
#endif
#if defined(CONFIG_KERNEL_MCS)
    SchedContextYieldTo,
#endif
    nInvocationLabels
};
#include <sel4/sel4_arch/invocation.h>
#include <sel4/arch/invocation.h>